/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.midlet.MIDlet;

public class Application
extends MIDlet
implements Runnable {
    private static Application m_CurrentInstance;
    private Thread m_Thread;
    private boolean m_ThreadIsRunnable;
    private int m_FrameRate;
    private long m_FrameTimeMillis;
    private long m_RecentTimeMillis;
    private long m_CurrentTimeMillis;

    public Application() {
        m_CurrentInstance = this;
        this.m_Thread = new Thread(this);
        this.m_ThreadIsRunnable = false;
        this.setFrameRate(10);
        this.m_Thread.start();
    }

    public void startApp() {
        this.m_ThreadIsRunnable = true;
    }

    public void pauseApp() {
        this.m_ThreadIsRunnable = false;
    }

    public void destroyApp(boolean unconditional) {
        this.m_Thread = null;
        this.m_ThreadIsRunnable = false;
    }

    public void run() {
        boolean isNotTerminated = true;
        this.m_RecentTimeMillis = 0L;
        while (isNotTerminated) {
            try {
                while (!this.m_ThreadIsRunnable) {
                    Thread.sleep(500L);
                }
                this.m_CurrentTimeMillis = System.currentTimeMillis();
                while (this.m_RecentTimeMillis >= this.m_FrameTimeMillis && isNotTerminated) {
                    isNotTerminated = this.update();
                    this.m_RecentTimeMillis -= this.m_FrameTimeMillis;
                }
                this.render();
                Application application = this;
                application.m_Thread.yield();
                while (System.currentTimeMillis() - this.m_CurrentTimeMillis <= 0L) {
                }
                this.m_CurrentTimeMillis = System.currentTimeMillis() - this.m_CurrentTimeMillis;
                this.m_RecentTimeMillis += this.m_CurrentTimeMillis;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public static Application getCurrent() {
        return m_CurrentInstance;
    }

    public void resetFrameTimer() {
        this.m_CurrentTimeMillis = System.currentTimeMillis();
    }

    public void setFrameRate(int fps) {
        this.m_FrameRate = fps;
        this.m_FrameTimeMillis = 1000 / this.m_FrameRate;
        this.m_RecentTimeMillis = 0L;
        this.m_CurrentTimeMillis = System.currentTimeMillis();
    }

    public int getFrameRate() {
        return this.m_FrameRate;
    }

    public boolean update() {
        return false;
    }

    public void render() {
    }

    public void yield() {
        try {
            Thread.sleep(500L);
            Application application = this;
            application.m_Thread.yield();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

